if IsDLCEnabled(CAPY_DLC) then
    return function(self, lootprefab, pt)
        if lootprefab then
            local loot = SpawnPrefab(lootprefab)
            if loot then
                if not pt then
                    pt = Point(self.inst.Transform:GetWorldPosition())
                end

                if self.inst.components.poisonable and self.inst.components.poisonable:IsPoisoned() and loot.components.perishable then
                    loot.components.perishable:ReducePercent(TUNING.POISON_PERISH_PENALTY)
                end
                
                loot.Transform:SetPosition(pt.x,pt.y,pt.z)

                self.inst:ApplyInheritedMoisture(loot)
                
                if loot.Physics and not self.nojump then
                    local angle = math.random()*2*PI
                    local speed = self.speed or 1
                    speed = speed * math.random()
                    loot.Physics:SetVel(speed*math.cos(angle), GetRandomWithVariance(8, 4), speed*math.sin(angle))

                    if loot and loot.Physics and self.inst and self.inst.Physics then
                        pt = pt + Vector3(math.cos(angle), 0, math.sin(angle))*((loot.Physics:GetRadius() or 1) + (self.inst.Physics:GetRadius() or 1))
                        loot.Transform:SetPosition(pt.x,pt.y,pt.z)
                    end
                end
                if loot.components.inventoryitem then 
                    loot.components.inventoryitem:OnLootDropped()
                end 
                
                return loot
            end
        end
    end
elseif IsDLCEnabled(REIGN_OF_GIANTS) then
    return function(self, lootprefab, pt)
        if lootprefab then
            local loot = SpawnPrefab(lootprefab)
            if loot then
                if not pt then
                    pt = Point(self.inst.Transform:GetWorldPosition())
                end
                
                loot.Transform:SetPosition(pt.x,pt.y,pt.z)

                local targetMoisture = 0

                if self.inst.components.moisturelistener then
                    targetMoisture = self.inst.components.moisturelistener:GetMoisture()
                elseif self.inst.components.moisture then
                    targetMoisture = self.inst.components.moisture:GetMoisture()
                else
                    targetMoisture = GetWorld().components.moisturemanager:GetWorldMoisture()
                end
                
                loot.targetMoisture = targetMoisture
                loot:DoTaskInTime(2*FRAMES, function()
                    if loot.components.moisturelistener then 
                        loot.components.moisturelistener.moisture = loot.targetMoisture
                        loot.targetMoisture = nil
                        loot.components.moisturelistener:DoUpdate()
                    end
                end)
                
                if loot.Physics then
                
                    local angle = math.random()*2*PI
                    local speed = math.random()
                    loot.Physics:SetVel(speed*math.cos(angle), GetRandomWithVariance(8, 4), speed*math.sin(angle))

                    if loot and loot.Physics and self.inst and self.inst.Physics then
                        pt = pt + Vector3(math.cos(angle), 0, math.sin(angle))*((loot.Physics:GetRadius() or 1) + (self.inst.Physics:GetRadius() or 1))
                        loot.Transform:SetPosition(pt.x,pt.y,pt.z)
                    end
                    
                    loot:DoTaskInTime(1, 
                        function() 
                            if not (loot.components.inventoryitem and loot.components.inventoryitem:IsHeld()) then
                                if not loot:IsOnValidGround() then
                                    local fx = SpawnPrefab("splash_ocean")
                                    local pos = loot:GetPosition()
                                    fx.Transform:SetPosition(pos.x, pos.y, pos.z)
                                    --PlayFX(loot:GetPosition(), "splash", "splash_ocean", "idle")
                                    if loot:HasTag("irreplaceable") then
                                        loot.Transform:SetPosition(GetPlayer().Transform:GetWorldPosition())
                                    else
                                        loot:Remove()
                                    end
                                end
                            end
                        end)
                end
                
                return loot
            end
        end
    end
else
    return function(self, lootprefab, pt)
        if lootprefab then
            local loot = SpawnPrefab(lootprefab)
            if loot then
                if not pt then
                    pt = Point(self.inst.Transform:GetWorldPosition())
                end
                
                loot.Transform:SetPosition(pt.x,pt.y,pt.z)
                
                if loot.Physics then
                    local angle = math.random()*2*PI
                    loot.Physics:SetVel(2*math.cos(angle), 10, 2*math.sin(angle))

                    if loot and loot.Physics and self.inst and self.inst.Physics then
                        pt = pt + Vector3(math.cos(angle), 0, math.sin(angle))*((loot.Physics:GetRadius() or 1) + (self.inst.Physics:GetRadius() or 1))
                        loot.Transform:SetPosition(pt.x,pt.y,pt.z)
                    end
                    
                    loot:DoTaskInTime(1, function() 
                        if not (loot.components.inventoryitem and loot.components.inventoryitem:IsHeld()) then
                            if not loot:IsOnValidGround() then
                                local fx = SpawnPrefab("splash_ocean")
                                local pos = loot:GetPosition()
                                fx.Transform:SetPosition(pos.x, pos.y, pos.z)
                                if loot:HasTag("irreplaceable") then
                                    loot.Transform:SetPosition(GetPlayer().Transform:GetWorldPosition())
                                else
                                    loot:Remove()
                                end
                            end
                        end
                    end)
                end
                
                return loot
            end
        end
    end
end